# Pre-Hospital Care System - Project Overview

## Executive Summary

The Pre-Hospital Care System represents a comprehensive digital transformation initiative developed specifically for Rescue 116, an emergency response unit operating under the Municipal Disaster Risk Reduction and Management Office (MDRRMO) section headed by Narciso Corpuz. Under the dedicated supervision of Sir Clifton Dichoso, who oversees the Rescue 116 unit, this web-based application has been meticulously designed to modernize and streamline the documentation processes that are critical to emergency medical services operations. The system empowers the team leaders who serve as the primary encoders, providing them with an intuitive, secure, and efficient platform to capture, manage, and analyze pre-hospital care data in real-time, ultimately enhancing the quality of emergency response documentation and patient care delivery across the municipality.

## Project Background and Purpose

The development of this system stems from the pressing need to digitize Rescue 116's emergency medical documentation workflow, which previously relied on static HTML forms or paper-based processes. Recognizing the challenges faced by Rescue 116 personnel in the field under the MDRRMO section led by Narciso Corpuz, particularly the team leaders who are responsible for encoding critical patient information during and after emergency responses, this application was conceived as a complete end-to-end solution. The system transforms the traditional TONYANG form into a fully functional, interactive web platform that respects the demanding nature of emergency medical work while ensuring data accuracy, security, and accessibility. With 38 commits of iterative development and refinement, the application has evolved into a production-ready tool that directly addresses the operational needs of Rescue 116 under Sir Clifton Dichoso's leadership, enabling team leaders to fulfill their encoding responsibilities with unprecedented efficiency and reliability.

## Technical Foundation and Architecture

Built on a robust technology stack comprising PHP 7.4+, MySQL 5.7+, Bootstrap 5, and Apache/Nginx web servers, the Pre-Hospital Care System embodies enterprise-grade architecture designed for stability, security, and scalability. The application employs a custom lightweight Model-View-Controller (MVC) inspired framework that separates concerns effectively, with core application logic housed in modular includes files, RESTful API endpoints handling all data operations, and user-facing pages managing presentation and interaction. The frontend leverages modern web technologies including Bootstrap 5.3.0 for responsive design, Flatpickr for mobile-optimized date and time selection, Chart.js for interactive data visualization, and Notiflix for elegant user notifications. This technical foundation ensures that team leaders encoding data from various devices, whether desktop computers at the office or mobile devices in the field, experience consistent performance and usability. The database architecture comprises five core tables supporting users, pre-hospital forms with over 80 fields, injury mappings, activity logs for comprehensive audit trails, and vehicle fleet management, all interconnected through properly defined foreign key relationships and indexed for optimal query performance.

## Core Functionality for Team Leaders and Encoders

At the heart of the system lies a sophisticated seven-section multi-step form that team leaders use to encode comprehensive pre-hospital care data. The form intelligently organizes data collection into manageable segments including basic information with form dates, times, and vehicle details; patient demographics capturing name, date of birth, age, gender, address, occupation, and incident location; emergency type classification distinguishing between medical, trauma, obstetric, and general cases with detailed notes; vital signs tracking for both initial and follow-up measurements including blood pressure, temperature, pulse, oxygen saturation, and pain scores; chief complaints and assessment data including FAST assessment for stroke screening and consciousness levels; team information documenting the various staff roles such as team leader, recorder, logistic coordinator, and aiders; and finally hospital endorsement details including receiving hospital, endorsement datetime, and patient signatures. The system features an innovative interactive body diagram where team leaders can click to mark injuries on front and back body views, selecting from six injury types including laceration, fracture, burn, contusion, abrasion, and other, with each injury marker preserving pixel-accurate coordinates and associated notes in the database. Vehicle selection is streamlined through a modal-based interface presenting Rescue 116's complete fleet of twelve ambulances identified as V1 through V12 with assigned plate numbers, plus two fire truck variants labeled Penetrator and Tanker, enabling accurate documentation of which unit responded to each emergency call.

## Security and Access Control for MDRRMO Operations

Understanding the sensitive nature of emergency medical data and the need to protect patient privacy while facilitating efficient operations for Rescue 116, the system implements multi-layered security measures that meet healthcare data protection standards. Authentication mechanisms include password hashing using bcrypt algorithms, session regeneration on login to prevent session fixation attacks, and IP-based rate limiting that restricts login attempts to ten per ten-minute period to thwart brute force attacks. The authorization framework employs Role-Based Access Control (RBAC) with three distinct roles: administrators like Sir Clifton Dichoso who have full system access for oversight and management; regular users representing the team leaders and encoders who can create forms, view and edit their own records, and access personal analytics; and viewers with read-only access for future expansion needs. Data protection is enforced through PDO prepared statements preventing SQL injection vulnerabilities, comprehensive input sanitization and validation that intelligently preserves data type integrity, output escaping using htmlspecialchars to prevent cross-site scripting attacks, and CSRF token validation for state-changing operations. Session security employs HTTPOnly cookies to prevent JavaScript access, SameSite policies that adapt between strict and lax modes based on client type, secure flags in production HTTPS environments, and Content Security Policy nonce generation unique to each session. The system maintains a complete audit trail through its activity logging module, recording every user action including logins, form submissions, edits, and deletions along with the associated user ID, action details in JSON format, IP address, and timestamp, providing Sir Clifton Dichoso with full visibility into system usage and ensuring accountability among the encoding team.

## Records Management and Data Isolation

The records management system has been thoughtfully designed to balance operational efficiency with data security and privacy for Rescue 116. Team leaders serving as encoders can seamlessly access their personally created records through an intuitive interface that provides advanced filtering by date range, status, and other criteria, along with bulk actions for efficient workflow management. The system automatically isolates data at the query level, ensuring that regular user accounts only retrieve records where the created_by field matches their user ID, effectively preventing unauthorized access to other team members' submissions without requiring complex client-side permission logic. For Sir Clifton Dichoso and other designated administrators, the records management interface expands to display all records from all users across the MDRRMO, enabling comprehensive oversight of Rescue 116's documentation activities, quality assurance reviews, and identification of training opportunities. Each record can transition through three states: draft status for work-in-progress submissions that team leaders can save and return to later, completed status for finalized forms ready for review and archival, and archived status for historical records that need long-term retention but should be separated from active operational data. The system supports complete CRUD operations with Create functionality through the main form interface, Read access via detailed record views that present all captured information in an organized, print-friendly format, Update capabilities allowing team leaders to correct or supplement their own submissions, and Delete functionality with appropriate safeguards and audit trail preservation.

## Analytics and Reporting for Leadership Oversight

Recognizing Sir Clifton Dichoso's need for data-driven insights to guide Rescue 116 operations and strategic planning, the system incorporates a comprehensive analytics and reporting dashboard that transforms raw form submissions into actionable intelligence. The reports module presents six key statistics cards displaying total forms submitted, completed forms count, forms submitted today, forms submitted this week, pending forms requiring review, and draft forms still in progress, giving leadership an instant snapshot of documentation activity and completion rates. The visual analytics suite includes a line chart tracking forms submission trends over time to identify patterns and seasonal variations, a doughnut chart breaking down forms by status to highlight workflow bottlenecks, a bar chart showing emergency type distribution revealing whether Rescue 116 responds more frequently to medical, trauma, obstetric, or general emergencies, a pie chart analyzing vehicle usage breakdown to inform fleet management and maintenance scheduling, a doughnut chart presenting patient gender distribution for demographic analysis, a bar chart categorizing patient age groups to understand the populations served, and a horizontal bar chart displaying injury type frequency to support training prioritization and equipment procurement decisions. All analytics respect the role-based access model, with team leaders viewing statistics filtered to their personal submissions while administrators like Sir Clifton Dichoso access system-wide data across all users. The reporting interface includes sophisticated filtering capabilities allowing analysis by date range, status, and user, with real-time chart updates and export functionality to generate CSV files for external analysis or integration with municipal reporting requirements.

## User Management and Team Administration

To support Sir Clifton Dichoso in managing the Rescue 116 encoding team, the system provides comprehensive user management capabilities through a dedicated administrative interface. The user management module enables creation of new accounts for team leaders joining the encoding staff, with role assignment that determines their access level within the system, mandatory fields for username, email, full name, and initial password with complexity validation ensuring security standards. Existing user accounts can be edited to update personal information, modify assigned roles as responsibilities change, or adjust status flags, with all modifications logged to the activity audit trail. Password management functionality allows administrators to reset user credentials when team leaders forget their passwords or when periodic password rotation policies require updates, with the system enforcing minimum complexity requirements including length, character variety, and protection against common passwords. User status can be toggled between active and inactive states, providing a mechanism to temporarily suspend access for team leaders on extended leave or who have transitioned to other roles without permanently deleting their historical contributions. A user restriction mechanism supports both automatic lockout after five consecutive failed login attempts and manual restriction by administrators, protecting against compromised credentials while giving Sir Clifton Dichoso the ability to immediately suspend accounts if security concerns arise. The user management interface includes search and filter functionality to quickly locate specific team members in growing staff rosters, status badges providing visual indicators of account health, and bulk operations for efficient administration of multiple accounts simultaneously.

## Mobile Optimization and Field Accessibility

Understanding that Rescue 116 team leaders often need to encode data while in the field, potentially from mobile devices in ambulances or at emergency scenes, the system has been carefully optimized for mobile accessibility and diverse device support. The responsive design built on Bootstrap 5 ensures that forms, records, and reports render appropriately across screen sizes from large desktop monitors in the office to small smartphone screens in the field, with touch-friendly interfaces that accommodate finger navigation rather than assuming mouse precision. The Flatpickr date and time picker integration provides mobile-optimized input controls that trigger native-style date and time selection interfaces on touch devices, eliminating the frustration of attempting to type formatted datetime strings on mobile keyboards. The system implements conditional security policies that detect mobile webview environments based on User-Agent strings, URL parameters, or custom HTTP headers, adapting SameSite cookie policies from strict to lax mode and adjusting CSRF enforcement to ensure compatibility with embedded browser contexts while maintaining appropriate security postures. Page load performance has been optimized through gzip compression, efficient database queries with proper indexing, and minimal external dependencies, ensuring that team leaders can access the system even on slower mobile data connections encountered in remote areas of the municipality. The auto-save functionality proves particularly valuable in mobile contexts where connectivity may be intermittent, automatically preserving draft progress at regular intervals so that encoders don't lose substantial data entry work if network issues force a session termination.

## Quality Assurance and Data Integrity

The system incorporates extensive quality assurance mechanisms to ensure that data encoded by Rescue 116 team leaders maintains the accuracy and integrity required for medical documentation and legal compliance. Client-side validation provides immediate feedback as team leaders complete form fields, catching common errors like missing required fields, invalid date formats, out-of-range numeric values, or logically inconsistent combinations before submission attempts, reducing frustration and improving data quality at the point of entry. Server-side validation implements redundant checks that cannot be bypassed through client manipulation, ensuring that only properly formatted and complete data enters the database regardless of how the submission reaches the API endpoints. Smart sanitization routines process input data to prevent injection attacks and normalize text formatting, with field-type awareness that prevents uppercase conversion of datetime values, preservation of JSON array structures for multi-select fields, and appropriate handling of special characters in text fields. The recent commit history demonstrates ongoing attention to data integrity, with fixes preventing sanitization from uppercasing date, time, and enum fields that should preserve their original format, improvements to datetime handling that accommodate various input formats and timezone considerations, and enhanced form validation that catches edge cases identified through real-world usage by the Rescue 116 team. Database constraints enforce referential integrity through foreign key relationships, ensure uniqueness of critical identifiers like form numbers and usernames, and prevent null values in required fields, providing defense-in-depth that complements application-level validation.

## Audit Trail and Compliance Support

For an emergency medical service operating under municipal government authority like Rescue 116, maintaining comprehensive audit trails serves both operational accountability and regulatory compliance requirements. The activity logging system captures every significant action within the application, creating an immutable record that Sir Clifton Dichoso can reference for quality assurance reviews, incident investigations, or responses to information requests. Each log entry records the user ID identifying which team leader or administrator performed the action, the action type categorizing the operation as login, form submission, edit, deletion, or other activities, detailed action information stored in JSON format preserving the complete context including before and after states for modifications, the IP address from which the action originated enabling detection of unusual access patterns or potential security incidents, and a precise timestamp marking when the event occurred for temporal analysis and sequence reconstruction. The logging system indexes entries for fast query performance even as the audit trail grows to thousands of records over months and years of operation, ensuring that searches for specific users, date ranges, or action types remain responsive. Regular maintenance routines automatically clean up ancillary records like rate limit tracking data older than 24 hours while preserving the core audit trail indefinitely, balancing database performance with retention requirements. This comprehensive logging enables Sir Clifton Dichoso to answer questions about when specific forms were created or modified, which team leader encoded particular data, what changes were made during edit operations, and whether any unusual access patterns suggest security concerns or training needs.

## Draft Management and Workflow Flexibility

Recognizing that team leaders encoding pre-hospital care data may need to pause their work due to incoming emergency calls, shift changes, or the need to verify information before finalizing submissions, the system provides robust draft management capabilities that enhance workflow flexibility for Rescue 116 operations. The auto-save functionality activates automatically at regular intervals as team leaders complete form sections, silently preserving their progress to the database without requiring explicit save actions or interrupting their data entry flow, ensuring that even if a browser crashes, a device loses power, or an urgent response requires abandoning the workstation, the encoded data remains safely stored and can be recovered when the team leader returns. Team leaders can explicitly save drafts at any stage of form completion, allowing them to capture partial information immediately after an emergency response when details are fresh, then return later to supplement the submission with additional data gathered through follow-up investigation or colleague consultation. The drafts management interface provides team leaders with a dedicated view of all their in-progress submissions, displaying key identifiers like form date, patient name if entered, and last modified timestamp, enabling quick identification and resumption of the appropriate draft when returning to complete documentation hours or even days after the initial response. Draft versioning preserves timestamps for each auto-save and explicit save operation, providing a chronological record of when information was entered that can prove valuable for reconstructing event timelines or identifying when critical details were first documented. Once team leaders have completed and verified all required information, they can convert a draft to a finalized completed submission through a single action, transitioning the record from their personal work-in-progress queue to the official repository accessible for review by Sir Clifton Dichoso and other authorized administrators.

## Fleet Management and Resource Tracking

The integrated vehicle management module addresses a critical operational need for Rescue 116 by tracking the utilization and status of the response fleet comprising twelve ambulances and two fire trucks. Each vehicle in the system is identified by a unique vehicle ID, classified by type as either ambulance or fire truck, further specified by subtype such as the Penetrator and Tanker variants for fire trucks, associated with its assigned plate number for cross-referencing with motor pool and insurance records, and tagged with a current status of available, in use, or under maintenance to inform dispatch decisions and fleet management planning. When team leaders encode pre-hospital care forms, the vehicle selection interface presents the complete Rescue 116 fleet in a user-friendly modal dialog, allowing quick identification and selection of the responding unit without requiring memorization of vehicle IDs or plate numbers. This vehicle data captured on each form enables Sir Clifton Dichoso to generate utilization reports showing which ambulances respond to the most calls, identify patterns that might indicate maintenance needs based on incident frequency, optimize fleet positioning to improve response times across the municipality's geography, and provide data-driven justification for fleet expansion or replacement in budget planning processes. The vehicle status management functionality allows designated administrators to mark units as under maintenance when repairs or inspections are required, update to in use during active incidents, and return to available status when units complete calls and are ready for dispatch, providing real-time visibility into fleet readiness that supports informed dispatch decisions.

## Implementation Journey and Continuous Improvement

The Pre-Hospital Care System has evolved through 38 documented commits representing a methodical development process that has progressively enhanced functionality, security, and usability based on the real-world needs of Rescue 116 and feedback from Sir Clifton Dichoso and the team leader encoders. Recent development efforts in January 2025 focused on refining data handling with fixes preventing sanitization from uppercasing date, time, and enum fields that should preserve their original format, ensuring data integrity and proper formatting in reports and exports. Features enforcing uppercase text input across the application provide standardization that improves data consistency and searchability, particularly valuable for patient names, addresses, and location descriptions where case variations can complicate record retrieval and analysis. Improvements to datetime handling enhance form validation, ensuring that team leaders receive clear feedback when date or time values are invalid and preventing submission of logically inconsistent temporal data like endorsement times that precede incident times. The integration of Flatpickr time picker with mobile optimization directly addresses feedback from team leaders who struggled with datetime entry on mobile devices, replacing problematic text input with professional, touch-friendly selection interfaces that work reliably across devices and browsers. Earlier development phases delivered the foundational features including the injury mapping system with body diagram and coordinate tracking, file upload support for patient documentation with MIME type validation, the draft auto-save functionality, hospital endorsement capture with signature files, narrative report generation, vehicle fleet management, and notification system integration with Notiflix. This ongoing commitment to refinement and enhancement demonstrates that the system remains actively maintained and responsive to user needs, with future improvements planned based on continued operational experience and evolving requirements from Rescue 116 leadership.

## Documentation and Knowledge Transfer

Supporting the successful adoption and long-term sustainability of the Pre-Hospital Care System for Rescue 116, the project includes comprehensive documentation spanning over twenty markdown files covering every aspect of the application. The README.md provides project overview and quick start guidance for new team members joining the encoding staff, while IMPLEMENTATION_GUIDE.md offers technical details for IT personnel responsible for deployment and maintenance. ROLE_BASED_ACCESS_GUIDE.md documents the access control model and permission matrices that define what each user type can access, ensuring consistent understanding of security boundaries. USER_MANAGEMENT_README.md explains the administrative procedures that Sir Clifton Dichoso and designated administrators use to create and manage team leader accounts. RECORDS_AUDITING_SUMMARY.md details the audit trail capabilities and how to investigate specific events or user activities. REPORTS_FEATURES.md describes the analytics and reporting functionality with guidance on interpreting charts and generating useful insights. RATE_LIMITING_AND_LOCKOUT.md explains the security measures protecting against brute force attacks and how to assist team leaders who have been locked out. SECURITY.md provides comprehensive security configuration guidance for IT personnel, while SECURITY_FIXES_APPLIED.md documents historical security improvements and lessons learned. BUG_FIXES_SUMMARY.md tracks resolved issues providing insight into common problems and their solutions. PRODUCTION_DEPLOYMENT_GUIDE.md walks through the complete deployment process from server setup through go-live, and TODO.md maintains the development roadmap with planned enhancements and feature requests. This documentation ensures that knowledge about the system resides not just with the original developers but is accessible to all stakeholders including team leaders, administrators like Sir Clifton Dichoso, IT support personnel, and future developers who may extend the system.

## Conclusion and Impact

The Pre-Hospital Care System represents a transformative tool specifically developed to serve the operational needs of Rescue 116, the Municipal Disaster Risk Reduction and Management Office emergency response unit under the supervision of Sir Clifton Dichoso. By empowering team leaders who serve as the primary encoders with an intuitive, secure, and comprehensive platform for documenting pre-hospital care, the system elevates the quality and efficiency of emergency medical documentation across the municipality. The application successfully bridges the gap between the demanding realities of field emergency response and the meticulous data capture required for quality patient care, operational analysis, and regulatory compliance. With its robust security model protecting sensitive patient information, role-based access control ensuring appropriate data isolation while enabling administrative oversight, comprehensive audit trails supporting accountability and continuous improvement, and mobile-optimized interface accommodating diverse usage contexts from office workstations to ambulances in the field, the system demonstrates production-grade quality suitable for deployment in healthcare settings where reliability and security are paramount. The ongoing development and refinement evidenced by 38 commits and extensive documentation reflects a commitment to meeting the evolving needs of Rescue 116, with a clear path forward for continued enhancement based on operational experience and leadership guidance from Sir Clifton Dichoso. This Pre-Hospital Care System stands as a testament to how thoughtfully designed technology can amplify the capabilities of dedicated emergency responders, enabling them to focus more time and energy on their life-saving mission while ensuring that the critical documentation supporting that mission is captured accurately, securely, and efficiently.
